/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 13:00:57 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "hamming.h"
#include "libmatlbm.h"
#include "libmmfile.h"
#include "signal_private_gencoswin.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;

static mxChar _array3_[7] = { 'h', 'a', 'm', 'm', 'i', 'n', 'g' };
static mxArray * _mxarray2_;

void InitializeModule_hamming(void) {
    _mxarray0_ = mclInitializeDouble(1.0);
    _mxarray1_ = mclInitializeDouble(2.0);
    _mxarray2_ = mclInitializeString(7, _array3_);
}

void TerminateModule_hamming(void) {
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Mhamming(int nargout_, mxArray * varargin);

_mexLocalFunctionTable _local_function_table_hamming
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfHamming" contains the normal interface for the "hamming"
 * M-function from file "c:\matlab65\toolbox\signal\signal\hamming.m" (lines
 * 1-24). This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfHamming(mxArray * synthetic_varargin_argument, ...) {
    mxArray * varargin = NULL;
    int nargout = 1;
    mxArray * w = NULL;
    mlfVarargin(&varargin, synthetic_varargin_argument, 1);
    mlfEnterNewContext(0, -1, varargin);
    w = Mhamming(nargout, varargin);
    mlfRestorePreviousContext(0, 0);
    mxDestroyArray(varargin);
    return mlfReturnValue(w);
}

/*
 * The function "mlxHamming" contains the feval interface for the "hamming"
 * M-function from file "c:\matlab65\toolbox\signal\signal\hamming.m" (lines
 * 1-24). The feval function calls the implementation version of hamming
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
void mlxHamming(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[1];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: hamming Line: 1 Column: "
            "1 The function \"hamming\" was called with mor"
            "e than the declared number of outputs (1)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    mlfEnterNewContext(0, 0);
    mprhs[0] = NULL;
    mlfAssign(&mprhs[0], mclCreateVararginCell(nrhs, prhs));
    mplhs[0] = Mhamming(nlhs, mprhs[0]);
    mlfRestorePreviousContext(0, 0);
    plhs[0] = mplhs[0];
    mxDestroyArray(mprhs[0]);
}

/*
 * The function "Mhamming" is the implementation version of the "hamming"
 * M-function from file "c:\matlab65\toolbox\signal\signal\hamming.m" (lines
 * 1-24). It contains the actual compiled code for that M-function. It is a
 * static function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function w = hamming(varargin)
 */
static mxArray * Mhamming(int nargout_, mxArray * varargin) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_hamming);
    int nargin_ = mclNargin(-1, varargin, NULL);
    mxArray * w = NULL;
    mxArray * msg = NULL;
    mxArray * ans = NULL;
    mclCopyArray(&varargin);
    /*
     * %HAMMING   Hamming window.
     * %   HAMMING(N) returns the N-point symmetric Hamming window in a column vector.
     * % 
     * %   HAMMING(N,SFLAG) generates the N-point Hamming window using SFLAG window
     * %   sampling. SFLAG may be either 'symmetric' or 'periodic'. By default, a 
     * %   symmetric window is returned. 
     * %
     * %   See also BARTLETT, BARTHANNWIN, BLACKMAN, BLACKMANHARRIS, BOHMANWIN, 
     * %            CHEBWIN, GAUSSWIN, HANN, KAISER, NUTTALLWIN, RECTWIN, TRIANG, 
     * %            TUKEYWIN, WINDOW.
     * 
     * %   Copyright 1988-2002 The MathWorks, Inc.
     * %   $Revision: 1.13 $  $Date: 2002/03/28 17:28:17 $
     * 
     * % Check number of inputs
     * error(nargchk(1,2,nargin));
     */
    mlfError(mlfNargchk(_mxarray0_, _mxarray1_, mlfScalar(nargin_)), NULL);
    /*
     * 
     * [w,msg] = gencoswin('hamming',varargin{:});
     */
    mlfAssign(
      &w,
      mlfSignal_private_gencoswin(
        &msg,
        _mxarray2_,
        mlfIndexRef(mclVa(varargin, "varargin"), "{?}", mlfCreateColonIndex()),
        NULL));
    /*
     * error(msg);
     */
    mlfError(mclVv(msg, "msg"), NULL);
    mclValidateOutput(w, 1, nargout_, "w", "hamming");
    mxDestroyArray(ans);
    mxDestroyArray(msg);
    mxDestroyArray(varargin);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return w;
    /*
     * 
     * 
     * % [EOF] hamming.m
     */
}
